# I repeat the simulation to see what happens with poorly specified models (breaks = 2,4,6 as opposite of default breaks = 10).

censor <- function(t, lambda = 1){

  n <- length(t)
  tL <- tR <- NULL
  for(i in 1:n){
    done <- FALSE
    vL <- 0
    while(!done){
      vR <- vL + rexp(1,lambda)
      if(t[i] <= vR){done <- TRUE; tL[i] <- vL; tR[i] <- vR}
      vL <- vR
    }
  }

  data.frame(tL = tL, tR = tR, t = t)
}

#########################################################################
#########################################################################
#########################################################################

sim1 <- function(n,lambda){
  x1 <- runif(n)
  x2 <- rexp(n)
  x3 <- rbinom(n, 1, 0.5)

  u <- runif(n)
  t <- (-1*log(1 - u)) + (3*u)*x1 + (3*u^2)*x2 + (3*sqrt(u))*x3
  Y <- censor(t,lambda)
  beta <- list(
   beta0 = function(tau){-1*log(1 - tau)},
   beta1 = function(tau){3*tau},
   beta2 = function(tau){3*tau^2},
   beta3 = function(tau){3*sqrt(tau)}
  )
  list(
    data = data.frame(t = Y$t, tL = Y$tL, tR = Y$tR, x1 = x1, x2 = x2, x3 = x3), 
    formula = formula(Surv(tL,tR, type = "interval2") ~ x1 + x2 + x3), beta = beta
  )
}

simulator2 <- function(sim, n = 1000, B = 1000, tau = c(0.2,0.4,0.6,0.8), print.each = 50, ...){

  test <- sim(n = 10, ...)
  q <- length(test$beta)
  r <- length(tau)
  true <- lapply(test$beta, function(b) b(tau))

  beta <- matrix(NA, B, r); colnames(beta) <- paste("tau =", tau)
  out <- list(); for(i in 1:q){out[[i]] <- beta}; names(out) <- paste0("beta",0:(q - 1))

  beta_icqr1 <- beta_icqr2 <- beta_icqr3 <- out
  est_se_icqr1 <- cover_icqr1 <- est_se_icqr2 <- cover_icqr2 <- est_se_icqr3 <- cover_icqr3 <- out
  time_icqr1 <- time_icqr2 <- time_icqr3 <- NULL

  for(i in 1:B){
    s <- sim(n, ...)
    tL <- s$data$tL; tR <- s$data$tR
    X <- s$data[, grep("x", names(s$data))]

    time_icqr1[i] <- system.time(m_icqr1 <- ctqr(s$formula, data = s$data, p = tau, CDF = pchreg(s$formula, breaks = 2, data = s$data)))[3]; V <- vcov(m_icqr1)
    time_icqr2[i] <- system.time(m_icqr2 <- ctqr(s$formula, data = s$data, p = tau, CDF = pchreg(s$formula, breaks = 4, data = s$data)))[3]; V <- vcov(m_icqr2)
    time_icqr3[i] <- system.time(m_icqr3 <- ctqr(s$formula, data = s$data, p = tau, CDF = pchreg(s$formula, breaks = 6, data = s$data)))[3]; V <- vcov(m_icqr3)

    for(j in 1:q){

      #######################################################
      beta.icqr1 <- m_icqr1$coef[j,]
      est.se.icqr1 <- sapply(V, function(x) sqrt(x[j,j]))
      low1 <- beta.icqr1 - 1.96*est.se.icqr1
      up1 <- beta.icqr1 + 1.96*est.se.icqr1

      beta_icqr1[[j]][i,] <- beta.icqr1
      est_se_icqr1[[j]][i,] <- est.se.icqr1
      cover_icqr1[[j]][i,] <- (low1 <= true[[j]] & up1 >= true[[j]])

      #######################################################
      beta.icqr2 <- m_icqr2$coef[j,]
      est.se.icqr2 <- sapply(V, function(x) sqrt(x[j,j]))
      low2 <- beta.icqr2 - 1.96*est.se.icqr2
      up2 <- beta.icqr2 + 1.96*est.se.icqr2

      beta_icqr2[[j]][i,] <- beta.icqr2
      est_se_icqr2[[j]][i,] <- est.se.icqr2
      cover_icqr2[[j]][i,] <- (low2 <= true[[j]] & up2 >= true[[j]])

      #######################################################

      beta.icqr3 <- m_icqr3$coef[j,]
      est.se.icqr3 <- sapply(V, function(x) sqrt(x[j,j]))
      low3 <- beta.icqr3 - 1.96*est.se.icqr3
      up3 <- beta.icqr3 + 1.96*est.se.icqr3

      beta_icqr3[[j]][i,] <- beta.icqr3
      est_se_icqr3[[j]][i,] <- est.se.icqr3
      cover_icqr3[[j]][i,] <- (low3 <= true[[j]] & up3 >= true[[j]])

    }

    if(round(i/print.each) == i/print.each){print(i)}
  }
  
  outfun <- function(true,beta){
    est <- colMeans(beta)
    se <- apply(beta,2,sd)
    mse <- colMeans((beta - t(matrix(true, length(true), nrow(beta))))^2)
    A <- cbind(true = true, est = est, mse = mse, se = se)
    rownames(A) <- colnames(beta)
    A
  }
  out_icqr1 <- out_icqr2 <- out_icqr3 <- list()
  for(j in 1:q){
   out_icqr1[[j]] <- outfun(s$beta[[j]](tau), beta_icqr1[[j]])
   out_icqr1[[j]] <- cbind(out_icqr1[[j]], est.se = colMeans(est_se_icqr1[[j]]), cover = colMeans(cover_icqr1[[j]]))

   out_icqr2[[j]] <- outfun(s$beta[[j]](tau), beta_icqr2[[j]])
   out_icqr2[[j]] <- cbind(out_icqr2[[j]], est.se = colMeans(est_se_icqr2[[j]]), cover = colMeans(cover_icqr2[[j]]))

   out_icqr3[[j]] <- outfun(s$beta[[j]](tau), beta_icqr3[[j]])
   out_icqr3[[j]] <- cbind(out_icqr3[[j]], est.se = colMeans(est_se_icqr3[[j]]), cover = colMeans(cover_icqr3[[j]]))
  }

  out <- list(beta_icqr1 = beta_icqr1, beta_icqr2 = beta_icqr2, beta_icqr3 = beta_icqr3,
    est_se_icqr1 = est_se_icqr1, cover_icqr1 = cover_icqr1, 
    est_se_icqr2 = est_se_icqr2, cover_icqr2 = cover_icqr2, 
    est_se_icqr3 = est_se_icqr3, cover_icqr3 = cover_icqr3, 

    out_icqr1 = out_icqr1, out_icqr2 = out_icqr2, out_icqr3 = out_icqr3, 

    tau = tau, true = s$beta,
    time = data.frame(icqr1 = time_icqr1, icqr2 = time_icqr2, icqr3 = time_icqr3))
  class(out) <- "sim2"
  out
}


print.sim2 <- function(x){

  q <- length(x$true)
  for(j in 1:q){
    cat("\n")
    print(paste0("beta", j - 1, ": icqr1"))
    cat("\n")
    print(round(x$out_icqr1[[j]],2))
    cat("\n")

    print(paste0("beta", j - 1, ": icqr2"))
    cat("\n")
    print(round(x$out_icqr2[[j]],2))
    cat("\n")

    print(paste0("beta", j - 1, ": icqr3"))
    cat("\n")
    print(round(x$out_icqr3[[j]],2))
    cat("\n")

    print("#######################################################")
    cat("\n")
  }
}

# Use var = 0 for the intercept, and var = j for x_j.
# Use what = "beta" for the betas, and what = "se" for the estimated standard errors of "icqr"

plot.sim2 <- function(obj, which = c("icqr1", "icqr2", "icqr3"), what = c("beta", "se"), var = 0){

  tau <- obj$tau
  which <- which[1]; what <- what[1]

  beta <- (if(which == "icqr1") obj$beta_icqr1[[var + 1]] else if(which == "icqr2") obj$beta_icqr2[[var + 1]] else obj$beta_icqr3[[var + 1]])
  se <- (if(which == "icqr1") obj$est_se_icqr1[[var + 1]] else if(which == "icqr2") obj$est_se_icqr2[[var + 1]] else obj$est_se_icqr3[[var + 1]])

  if(what == "beta"){target <- beta; name <- "beta"}
  else{target <- se; name <- "est.se"}


  title <- (if(var == 0) "Intercept" else paste0("x", var))
  for(j in 1:ncol(target)){

   hist(target[,j], main = title, xlab = paste0(name, var, "(",tau[j],") --- ", which), br = 100)

   if(what == "beta"){
     abline(v = obj$true[[var + 1]](tau[j]), col = "red", lwd = 2)
   }
   else{
     if(which == "icqr1") abline(v = obj$out_icqr1[[var + 1]][j,"se"], col = "red", lwd = 2)
     if(which == "icqr2") abline(v = obj$out_icqr1[[var + 1]][j,"se"], col = "red", lwd = 2)
     if(which == "icqr3") abline(v = obj$out_icqr1[[var + 1]][j,"se"], col = "red", lwd = 2)
   }
  }
}


library(ctqr)
B <- 1000
tau <- c(0.1,0.25,0.75,0.9)

#################################################################################################
#################################################################################################
#################################################################################################

# Note 1: the actual time-to-event is typycally between 0 and 20.
# Note 2: the first-step is defined by pchreg(formula, breaks = 2/4/6, splinex = NULL)

# Simulation 1: the time between visits is an Exp(2) variable
set.seed(1234); S1 <- simulator2(sim1, n = 250, B = B, tau = tau, lambda = 2)
set.seed(1234); T1 <- simulator2(sim1, n = 500, B = B, tau = tau, lambda = 2)

# Simulation 2: the time between visits is an Exp(1) variable
set.seed(1234); S2 <- simulator2(sim1, n = 250, B = B, tau = tau, lambda = 1)
set.seed(1234); T2 <- simulator2(sim1, n = 500, B = B, tau = tau, lambda = 1)

save.image("C:\\Users\\Paolo Frumento\\Desktop\\sensitivity_to_first_step")

S1
T1
S2
T2

#################################################################################################
#################################################################################################
# Some checks ###################################################################################
#################################################################################################
#################################################################################################

s <- S2 # replace S1,T1,S2,T2
par(mfrow = c(2,2))

plot(s, which = "icqr1", var = 0)
plot(s, which = "icqr1", var = 1)
plot(s, which = "icqr1", var = 2)
plot(s, which = "icqr1", var = 3)

plot(s, which = "icqr2", var = 0)
plot(s, which = "icqr2", var = 1)
plot(s, which = "icqr2", var = 2)
plot(s, which = "icqr2", var = 3)

plot(s, which = "icqr3", var = 0)
plot(s, which = "icqr3", var = 1)
plot(s, which = "icqr3", var = 2)
plot(s, which = "icqr3", var = 3)

# Checking estimated standard errors of icqr1, icqr2, icqr3

plot(s, which = "icqr1", var = 0, what = "se")
plot(s, which = "icqr1", var = 1, what = "se")
plot(s, which = "icqr1", var = 2, what = "se")
plot(s, which = "icqr1", var = 3, what = "se")

plot(s, which = "icqr2", var = 0, what = "se")
plot(s, which = "icqr2", var = 1, what = "se")
plot(s, which = "icqr2", var = 2, what = "se")
plot(s, which = "icqr2", var = 3, what = "se")

plot(s, which = "icqr3", var = 0, what = "se")
plot(s, which = "icqr3", var = 1, what = "se")
plot(s, which = "icqr3", var = 2, what = "se")
plot(s, which = "icqr3", var = 3, what = "se")

# Checking times

par(mfrow = c(1,3))
for(j in 1:3){hist(S1$time[[j]], main = paste0(names(S1$time)[j], " --- mean =", round(mean(S1$time[[j]]),3)))}
for(j in 1:3){hist(T1$time[[j]], main = paste0(names(T1$time)[j], " --- mean =", round(mean(T1$time[[j]]),3)))}
for(j in 1:3){hist(S2$time[[j]], main = paste0(names(S2$time)[j], " --- mean =", round(mean(S2$time[[j]]),3)))}
for(j in 1:3){hist(T2$time[[j]], main = paste0(names(T2$time)[j], " --- mean =", round(mean(T2$time[[j]]),3)))}

g <- function(x){round(c(mean = mean(x), sd = sd(x), me = median(x), Q1 = quantile(x, 0.25), Q2 = quantile(x, 0.75)),2)}
sapply(S1$time, g)
sapply(T1$time, g)
sapply(S2$time, g)
sapply(T2$time, g)




